; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        graph53
; -----------------------------------------------------------------
;   Description Contour plot of the density of the standard bivariate
;               normal distribution colored after a HLS color scheme.
; -----------------------------------------------------------------
  library("plot")              ; loads the library plot
  h   = grid (120,26.6666,4)   ; creates grid in HLS double cone
  l   = 0.5.*matrix(rows(h))
  s   = matrix(rows(h))
  rgb = hls2rgb(h~l~s)         ; transfers HLS model to RGB model
  x0 = #(-3, -3)
  h  = #(0.2, 0.2)
  n  = #(31, 31)
  x  = grid(x0, h, n)          ; generates a bivariate grid
  f  = exp(-(x[,1]^2+x[,2]^2)/1.5)/(1.5*pi)  
                               ; computes density of bivariate 
                               ;    normal with correlation 0.5
  c  = 0.2*(1:4).*max(f)       ; contour lines as 10%,...,90% 
                               ;    times the maximum density
  createcolor(rgb)             ; generates the necessary colors
  gr = grcontour2(x~f, c, rgb) ; generates surface
  plot(gr)                     ; plots the surface
