; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        regr4
; -----------------------------------------------------------------
;   Description  Nonlinear regression.
; -----------------------------------------------------------------
  library("graphic")   ; reads the library graphic
  library("stats")     ; reads the library stats
;
  randomize(0)         ; sets a seed for the random generator
  x=2*uniform(20)-1    ; generates 20 on [-1,1] uniform
                       ;    distributed values
  eps=normal(20)       ; generates 20 standard normal distributed
                       ;    values
  y=2*x^2+eps/2        ; creates y
;
  xtrans=x^2           ; transforms x into the variable xtrans
  x~xtrans~y           ; outoputs the ganerated and the 
                       ;    transformeddata
  {beta,bse,bstan,bpval}=linreg(xtrans,y)
                       ; computes the linear regression

  data=sort(x~y)             ; creates the graphical object for
                             ;    the data
  data=setmask(data,"blue","cross")
                             ; sets the options for the graphical
                             ;    object data
  rx=#(-10:10)/10            ; creates the vector (-1,-0.9,...,1)
  yq=(beta[2]*rx^2)          ; creates vector with the regressed
                             ;    values
  rdata=sort(rx~yq)          ; creates the graphical object for
                             ;    the regressed values
  rdata=setmask(rdata,"line","red")
                             ; sets the options for the graphical
                             ;    object rdata
  rf=sort(rx~2*rx^2)         ; creates the graphical object for
                             ;    the original function
  rf=setmask(rf,"line","green")
                             ; sets the options for the graphical
                             ;    object rf
  nlplot=createdisplay(1,1)  ; creates the display nlplot
  show(nlplot,1,1,data,rdata,rf) ;shows the display nlplot
  setgopt(nlplot,1,1,"title","Nonlinear Regression")
                             ; sets the title of the display


