; -----------------------------------------------------------------             
; Library        xlg                                                            
; -----------------------------------------------------------------             
;  See_also                                                                     
; -----------------------------------------------------------------
;   Macro        start06
; -----------------------------------------------------------------
;   Description  Example quantlet which reads data, and performs
;                an interactive bandwidth selection for kernel
;                regression.
; -----------------------------------------------------------------
  proc()=interactive(x)
    error(cols(x)!=2,"x has more than 2 columns!")
    x=setmask(x,"red","cross")
    h=(max(x[,1])-min(x[,1]))/5
    stop=0
    while (stop!=1)
      mh=setmask(regxest(x,h),"line")
      plot(x,mh)
      hnew=readvalue("Bandwidth h (0 to stop)",h)
      while (hnew<0)
        hnew=readvalue("Bandwidth h (0 to stop)",h)
      endo
      if (hnew!=0)
        h=hnew
      else
        stop=1
      endif
    endo
  endp
  
  library("plot")
  library("smoother")
  x=read("nicfoo")
  setsize(500,500)
  interactive(x)
