; ----------------------------------------------------------------------------
; Library        xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro          cart02 
; ----------------------------------------------------------------------------
; Description    finds the initial regression tree for 100 simulated
;                data from function f(x1,x2)
; ----------------------------------------------------------------------------
     proc(y)=tuto(seed,n)
       randomize(seed)
       xdat=uniform(n,2)
       ydat=120.*matrix(n,1)-(xdat[,2]<=0.5).*120
       ydat=ydat+(xdat[,2]>0.5).*(xdat[,1]<=0.5).*20
       ydat=ydat+normal(n)
       y=list(xdat,ydat)
     endp

     library("xclust")
     data=tuto(1,100)
     type=#(1,1)
     opt=cartsplitopt("minsize",1,"mindev",0,"mincut",5)
     tr=cartsplit(data.xdat,data.ydat,type,opt)
     totleaves=leafnum(tr,1)
     totleaves
     plotcarttree(tr)    