; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      dpls
; ----------------------------------------------------------------------------
; Macro         dpls01
; ----------------------------------------------------------------------------
; Description   example for creating and estimating a simple model with DPLS
;		for simulated data
; ----------------------------------------------------------------------------
library("metrics")
randomize(13409)
b1=0.3
c1=0.6
s=500
n1=normal(s+1)
n1lag=n1[1:s,]
n1=n1[2:rows(n1),] ;innermodel
n2=b1*n1+c1*n1lag+normal(rows(n1))/5
n=n1~n2
nn=n./sqrt(var(n)) ;loadingsmatrix
p=(1|2|3|4|0|0|0)~(0|0|0|0|5|6|7)
y=nn*p'+normal(rows(n),rows(p))/8
d=(0|1)~(0|0)
dl=(0|1)~(0|0)
w=(1|1|1|1|0|0|0)~(0|0|0|0|1|1|1)
myfit=dpls(w,d,w,dl,y,1,3)
myfit.b
myfit.sk
myfit.skl
