; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         flts02
; ----------------------------------------------------------------------------
; Description   Nadaraya-Watson estimate of NAR(1) model for lynx data
; ----------------------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;	data preparation	
  lynx		= read("lynx.dat")
  lynxrows 	= rows(lynx)				
  lag1		= lynx[1:lynxrows-1]  			; vector of first lag
  y   		= lynx[2:lynxrows]    			; vector of dep. var.
  data 		= lag1~y	
  data		= log(data)	   
;	estimation
  h		= 0.2*(max(data[,1])-min(data[,1]))	; crude bandwidth choice
  "Bandwidth used" h
  mh		= regxest(data,h)			; N-W estimation
; 	graphics
  mh		= setmask(mh,"line","blue")			
  xy		= setmask(data,"cross","small")
  plot(xy,mh)
  setgopt(plotdisplay,1,1,"title","Estimated NAR(1) mean function","xlabel","First Lag","ylabel","Lynx")