; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      intest2d
; ----------------------------------------------------------------------------
; Macro         gam07
; ----------------------------------------------------------------------------
; Description   estimates bivariate marginal influence for simulated data
; ----------------------------------------------------------------------------
library("gam")
randomize(12345)
t     = grid(#(-0.9,-0.9),#(0.2,0.2),#(10,10))
n     = rows(t)
t     = t~(uniform(n)*2-1)
g3    = sin(2*t[,3])
g12   = t[,1].*t[,2]^2
y     = g3 + g12 + normal(n)*sqrt(0.5)
h     = #(1.0, 1.0)
g     = #(1.1, 1.1, 1.2)
loc   = 1
gest  = intest2d(t,y,h,g,loc)
library("graphic")
pic  = createdisplay(1,2)
dat11 = grsurface(t[,1:2]~g12)
dat12 = grsurface(t[,1:2]~gest[,1])
gc = grcube( dat11|dat12 )
show(pic,1,1,dat11,gc.box,gc.x,gc.y,gc.z,gc.c)
show(pic,1,2,dat12,gc.box,gc.x,gc.y,gc.z,gc.c)
setheadline(pic, 1, 1, "Original function")
setheadline(pic, 1, 2, "Estimated function")
; rotate view
m=#(0.70711, -0.70710, 1.1545e-5)~#(0.13795,0.13797, 0.98078)~#(-0.69351,-0.69352,0.19510)
setgopt(pic, 1, 1, "rotcos", m)
setgopt(pic, 1, 2, "rotcos", m)

