; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      gplmest gplmout
; ----------------------------------------------------------------------------
; Macro         gplm02
; ----------------------------------------------------------------------------
; Description   GPLM estimation for the Credit data
;               (using the default Speckman algorithm).
; ----------------------------------------------------------------------------
  file=read("kredit")  
  file=paf(file,(file[,5]>=1)&&(file[,5]<=3)) 
                                     ; purpose=car/furniture
  y=file[,1]
  x=(file[,4]>2)                     ; previous loans o.k.
  x=x~(file[,8]>2)                   ; employed (>=1 year)
  x=x~(file[,3])                     ; duration of loan
  t=(file[,6])                       ; amount of loan
  t=t~(file[,14])                    ; age of client
  xvars="previous"|"employed"|"duration"
  tvars="amount"|"age"
;
  library("gplm")
;
  t=log(t)               ; logs of amount and age
  trange=max(t)-min(t)
  t=(t-min(t))./trange   ; transformation to [0,1]
;
  h=0.4
  g=gplmest("bilo",x,t,y,h)
  gplmout("bilo",x,t,y,h,g.b,g.bv,g.m,g.stat)
  g.b
