; -----------------------------------------------------------------
; Library        GRAPH
; -----------------------------------------------------------------
;   Macro        graph32
; -----------------------------------------------------------------
;   Description  Rescaled boxplot.
; -----------------------------------------------------------------
  library("plot")                ; loads library plot
  data = read ("bostonh")        ; reads Boston Housing data
  x = data[,14]                  ; selects the 14th column  
  gr = grbox(x)                  ; generates graphical object
  scale = #(min(x),max(x))~#(-1, 2) ; generates scaling data set
  scale = setmask(scale,"white") ; makes scaling data "invisible"
  plot(gr, scale)                ; plots boxplot and scaling data
