; -----------------------------------------------------------------
; Library        GRAPH
; -----------------------------------------------------------------
;   Macro        graph43
; -----------------------------------------------------------------
;   Description  Contour plot of the bivariate normal density.
; -----------------------------------------------------------------
  library ("plot")         ; loads the library plot
  x0 = #(-3, -3)              
  h  = #(0.2, 0.2)
  n  = #(31, 31)
  x  = grid(x0, h, n)      ; generates a bivariate grid
  f  = exp(-(x[,1]^2+x[,2]^2)/1.5)/(1.5*pi)
                           ; computes density of bivariate 
                           ;    normal with correlation 0.5
  c  = 0.2*(1:4).*max(f)   ; selects contour lines as 10%,...,90% 
                           ;    times the maximum density
  gr = grcontour2(x~f, c)  ; generates contours
  plot(gr)                 ; plots the contours
