; -----------------------------------------------------------------
; Library        GRAPH
; -----------------------------------------------------------------
;   Macro        graph52
; -----------------------------------------------------------------
;   Description  Coordinate axes, $95\%$ mass circle and
;                random sample of a bivariate standard normal distribution.
; -----------------------------------------------------------------
  library("graphic")        ; loads library graphic
  randomize(0)              ; initializes random generator
  x  = normal(200,2)        ; generates 200 bivariate data
  xl = grxline(0, x[,1])    ; computes horizontal axis
  yl = gryline(0, x[,2])    ; computes vertical axis
  cl = grcircle(2.44775)    ; computes circle with radius 2.44775
  d  = createdisplay(1,1)   ; creates display
  show(d,1,1,x,xl,yl,cl)    ; draws everything in one plot
