; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      steps4plot hazkpm
; ----------------------------------------------------------------------------
; Macro         haz04
; ----------------------------------------------------------------------------
; Description   calculates and plots the Kaplan-Meier estimator for 
;		simulated data
; ----------------------------------------------------------------------------
 library("hazreg")
 dat=read("haz01.dat")  
 t = dat[,1]                         ; observed times                      
 delta = dat[,2]                     ; censoring indicator                       
 z = dat[,3:4]                       ; covariates  
 {data,ties} = hazdat(t,delta, z)    ; preparing data
 {cil,kme,ciu} = hazkpm(data)        ; compute kme and confidence limits

 setsize(600,400)                    ; initiating graph    
 plot1=createdisplay(1,1)            ; initiating graph        
 n = rows(data)                      ; sample size
 pm = (#(1,n+2)'+ (0:n))|(#(2*n+2,3*n+3)'+ (0:n))
                                     ; points to be connected
 cn = matrix(2*n+2)                  ; color_num, controls colors
 ar = matrix(2*n+2)                  ; art, controls line types
 th = matrix(2*n+2)                  ; thick, controls line thickness 

 cilline = steps4plot(cil)           ; points for step function plot
 setmaskl(cilline, pm, cn, ar, th)   ; lines control
 setmaskp(cilline, 4, 0, 8)          ; points control 

 ciuline = steps4plot(ciu)           ; points for step function plot
 setmaskl(ciuline, pm, cn, ar, th)   ; lines control
 setmaskp(ciuline, 4, 0, 8)          ; points control

 kmeline = steps4plot(kme, 0~1)      ; points for step function plot
 setmaskl(kmeline, pm, cn, ar, 2*th) ; lines control
 setmaskp(kmeline, 4, 0, 8)          ; points control

 show(plot1, 1, 1, cilline, kmeline, ciuline)  
 setgopt(plot1, 1, 1, "title","Kaplan-Meier Estimates")
 setgopt(plot1, 1, 1, "xlabel","Time","ylabel","Survival Function","ymajor",0.2) 
; uncomment the following line for a PS picture
; print (plot1,"hazkpmtest.ps")     
