; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      haztest
; ----------------------------------------------------------------------------
; Macro         haz09
; ----------------------------------------------------------------------------
; Description   tests the significance of the parameters estimates 
;		in Cox model for simulated data
; ----------------------------------------------------------------------------
 library("hazreg") 
 dat=read("haz01.dat")  
 t = dat[,1]                        ; observed times                      
 delta = dat[,2]                    ; censoring indicator                       
 z = dat[,3:4]                      ; covariates              
 {data,ties} = hazdat(t,delta, z)   ; preparing data
 index = 1|0                        ; testing if the second
                                    ; coefficient is zero

 {testt, val,df,pval} = haztest(data, index)
  testt                             ; print summary table
         
         
        
