 library("hazreg") 
 dat=read("haz.dat")  
 y = dat[,1]                        ; survival time
 c = dat[,2]                        ; censoring variable
 z = dat[,3:4]                      ; covariates
 t = min(y~c,2)                     ; censored time             
 delta = (y<=c)                     ; censoring indicator            
 {data,ties} = hazdat(t,delta, z)   ; preparing data
 setsize(600,400)
 t1=createdisplay(1,1)
 t2=createdisplay(1,1)
 {bhaz,bsurv} = hazbase(data)
 n = rows(data) 
 t = bsurv[2:n,1]
 b = bsurv[1:n-1,2]
 bsurv = ((bsurv[1:n-1,])|(t~b))|((t~b)|(bsurv[2:n,]))
 pm = (#(1,n)'+ (0:n-2))|(#(2*n-2,3*n-3)'+ (0:n-2))
 cn = matrix(2*n-2)                  ;  color_num, controls colors
 ar = matrix(2*n-2)                  ;  art, controls line types
 th = matrix(2*n-2)                  ;  thick, controls line thickness
 setmaskl(bsurv ,pm ,cn , ar, th)
 setmaskp(bsurv, 4, 0, 8) 
 b = bhaz[1:n-1,2]
 bhaz = ((bhaz[1:n-1,])|(t~b))|((t~b)|(bhaz[2:n,]))
 setmaskl(bhaz, pm ,cn , ar, th)
 setmaskp(bhaz, 4, 0, 8) 
 show(t1, 1, 1, bhaz)                ; plot baseline hazard
 setgopt(t1,1,1, "title","Baseline Hazard Function","xlabel","Time","ylabel","Hazard Function",  "ymajor", 0.2)
 print (t1,"hazbhaztest.ps")             
 show(t2,1, 1, bsurv)                ; plot baseline survival
 setgopt(t2,1,1, "title","Baseline Survival Function","xlabel","Time","ylabel","Survival  Function",  "ymajor", 0.2)
 print (t2,"hazbsurvtest.ps")             
