 library("hazreg")
 dat=read("haz.dat")  
 y = dat[,1]                        ; survival time
 c = dat[,2]                        ; censoring variable
 z = dat[,3:4]                      ; covariates            
 t = min(y~c,2)                     ; censored time             
 delta = (y<=c)                     ; censoring indicator                       
 {data,ties} = hazdat(t,delta, z)   ; preparing data
 setsize(600,400)      
 t1=createdisplay(1,1)        
 {cil,kme,ciu} = hazkpm(data)
 n = rows(data)
 t = cil[2:n,1]
 c = cil[1:n-1,2]
 cil = ((cil[1:n-1,])|(t~c))|((t~c)|(cil[2:n,]))
 pm = (#(1,n)'+ (0:n-2))|(#(2*n-2,3*n-3)'+ (0:n-2))
 cn = matrix(2*n-2)                  ;  color_num, controls colors
 ar = matrix(2*n-2)                  ;  art, controls line types
 th = 2*matrix(2*n-2)                ;  thick, controls line thickness
 setmaskl(cil ,pm ,cn , ar, th)
 setmaskp(cil, 4, 0, 8) 
 c = ciu[1:n-1,2]
 ciu = ((ciu[1:n-1,])|(t~c))|((t~c)|(ciu[2:n,]))
 setmaskl(ciu ,pm ,cn , ar, th)
 setmaskp(ciu, 4, 0, 8)
 k = kme[1:n-1,2]
 kme = ((kme[1:n-1,])|(t~k))|((t~k)|(kme[2:n,]))
 setmaskl(kme ,pm ,cn , ar, 2*th)
 setmaskp(kme, 4, 0, 8)
 show(t1,1,1,cil, kme, ciu)  
 setgopt(t1,1,1, "title","Kaplan-Meier Estimates", "xlabel","Time","ylabel","Survival Function",  "ymajor", 0.2) 
 print (t1,"hazkpmtest.ps")     
