; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      epscontnorm calibrIC rICfil kfilter2
; ----------------------------------------------------------------------------
; Macro         rkalm08
; ----------------------------------------------------------------------------
; Description   calculates classical Kalman filter and rIC filter for
;		data with 10% of additive outliers
; ----------------------------------------------------------------------------
library("times")
library("plot")
library("kalman")

T=50
e=0.1

           
mu = #(20,0)
Sig = #(0,0)~#(0,0)
H  = #(0.3,-0.3)~#(1,1)
F  = #(1,0)~#(1,0)
R  = #(0,0)~#(0,9)
mid=#(0,0)
Qid= #(9,0)~#(0,9)
mcont=#(25,30)
Qcont=0.1.*Qid
AOr=0.1

randomize(0)
ErrX = epscontnorm(T,0,mid,R,mcont,Qcont,0) 
ErrY = epscontnorm(T,AOr,mid,Qid,mcont,Qcont,0)
sim = kemitor2(T,mu,H,F,(ErrY.X),(ErrX.X))
y=sim.Y        
Xact=sim.X     

N=300
eps=0.01
itmax=15
aus=4
fact=1.2
expl=2
A0=0     
b0=-1    
typ= 0   


ergIC=calibrIC(T,Sig,H,F,Qid,R,typ,A0,b0,e,N,eps,itmax,expl,fact,aus)

A=ergIC.A
b=ergIC.b

res = kfilter2(y,mu,Sig, H,F,Qid,R)
fx = res.filtX
res= rICfil(y,mu,Sig,H,F,Qid,R,typ,A,b)
frx = res.filtX

i=(1:T)

Xact1 = i~(Xact[,1])
Xact1 = setmask(Xact1, "line", "blue", "thin")
fx1 = i~(fx[,1])
fx1 = setmask(fx1, "line", "red", "thin")
frx1= i~(frx[,1])
frx1 = setmask(frx1, "line", "green", "thin")

ym1=max(vec( (Xact[,1])~(fx[,1])~(frx[,1]) ) ) ;Ind-flags on top of graphics
ym2=min(vec( (Xact[,1])~(fx[,1])~(frx[,1]) ) )  ;clip-flags on bottom of graphics

flagInd=i~(ErrY.Ind)
flagInd=paf(flagInd,flagInd[,2]==1)
flagInd[,2]=ym1*((ym1>0)*1.1+(ym1<0)*0.9)

flagclip=i~(res.clipInd)
flagclip=paf(flagclip,flagclip[,2]==1)
flagclip[,2]= ym2*((ym2<0)*1.1+(ym2>0)*0.9)

setmaskp(flagInd,4, 3, 4)  
setmaskp(flagclip,2, 4, 4)  

disp = createdisplay(1,2)
show(disp,1,1,Xact1,fx1,frx1,flagInd,flagclip)
setgopt(disp,1,1, "title", "simulated Model under AO -- 1st coord.")
setgopt(disp,1,1, "xlabel", "t") 
setgopt(disp,1,1, "ylabel", "x, rIC-sim, Kalman") 

Xact2 = i~(Xact[,2])
Xact2 = setmask(Xact2, "line", "blue", "thin")
fx2 = i~(fx[,2])
fx2 = setmask(fx2, "line", "red", "thin")
frx2= i~(frx[,2])
frx2 = setmask(frx2, "line", "green", "thin")

ym1=max(vec( (Xact[,2])~(fx[,2])~(frx[,2]) ) )
ym2=min(vec( (Xact[,2])~(fx[,2])~(frx[,2]) ) )

flagInd[,2]=ym1*((ym1>0)*1.1+(ym1<0)*0.9)
flagclip[,2]= ym2*((ym2<0)*1.1+(ym2>0)*0.9)

setmaskp(flagInd,4, 3, 4)  
setmaskp(flagclip,2, 4, 4)  

show(disp,1,2,Xact2,fx2,frx2,flagInd,flagclip)
setgopt(disp,1,2, "title", "simulated Model under AO -- 2nd coord.")
setgopt(disp,1,2, "xlabel", "t") 
setgopt(disp,1,2, "ylabel", "x, rIC-sim, Kalman") 
