; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      seq
; ----------------------------------------------------------------------------
; Macro         seq02
; ----------------------------------------------------------------------------
; Description   Estimates model of european money demand
; ----------------------------------------------------------------------------
  library("metrics")
  ; reading in the data
  z=read("eu")
  ; getting rid of missing values due to lagged variables
  z=z[4:rows(z),]
  ; assigning columns of z to variable names
  dmp       =  z[,4]  
  dmp1      =  z[,5]  
  dy        =  z[,7]  
  dy1       =  z[,8]  
  d2p       =  z[,12]  
  d2p1      =  z[,13]  
  dil       =  z[,15]  
  dil1      =  z[,16]  
  dik       =  z[,18]  
  dik1      =  z[,19]  
  ec11      =  z[,21]  
  ec21      =  z[,23]  
  ; creating the matrices for seqlist1
  lhs=dmp~dy~dil~dik~d2p
  one= matrix(rows(z),1)
  z1=one~dmp1~dy1~dil1~dik1~d2p1~d2p~ec11
  z2=one~dmp1~dy1~dil1~dik1~d2p1~ec11~ec21
  z3=one~dmp1~dy1~dil1~dik1~d2p1
  z4=one~dmp1~dy1~dil1~dik1~d2p1~dil
  z5=one~dmp1~dy1~dil1~dik1~d2p1~ec21
  x=one~dmp1~dy1~dil1~dik1~d2p1~ec11~ec21
  ; forming seqlist1 as a list of matrices
  seqlist1=list(lhs,z1,z2,z3,z4,z5,x)
  ; creating list of string vectors
  yl="dmp"|"dy"|"dzl"|"dzk"|"d2p"
  zl1="one"|"dmp1"|"dy1"|"dil1"|"dik1"|"d2p1"|"d2p"|"ec11"
  zl2="one"|"dmp1"|"dy1"|"dil1"|"dik1"|"d2p1"|"ec11"|"ec21"
  zl3="one"|"dmp1"|"dy1"|"dil1"|"dik1"|"d2p1"
  zl4="one"|"dmp1"|"dy1"|"dil1"|"dik1"|"d2p1"|"dil"
  zl5="one"|"dmp1"|"dy1"|"dil1"|"dik1"|"d2p1"|"ec21"
  xl="one"|"dmp1"|"dy1"|"dil1"|"dik1"|"d2p1"|"ec11"|"ec21"
  ; forming seqlist2 as a list of string vectors
  seqlist2=list(yl,zl1,zl2,zl3,zl4,zl5,xl)
  ; finally, calling seq to estimate the model
  {d3sls,cov3,d2sls}=seq(seqlist1,seqlist2)
