; -----------------------------------------------------------------
; Library        SMOO
; -----------------------------------------------------------------
;   Macro        smoo15
; -----------------------------------------------------------------
;   Description  Compares a two-dimensional Nadaraya-Watson and a
;                two-dimensional local linear regression.
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;
  randomize(0)
  n=200
  x=uniform(n,2)
  m=sin(2*pi*x[,1])+x[,2]
  y=m+normal(n)/4
  ;
  mh= regxestp(x~y)
  ml=lregxestp(x~y)
  mh=setmask(mh,"surface","red")
  ml=setmask(ml,"surface","blue")
  ;
  c=grcube(mh)
  d=createdisplay(1,2)
  axesoff()
  show(d,1,1,mh,c.box,c.x,c.y)
  show(d,1,2,ml,c.box,c.x,c.y)
  axeson()
  setgopt(d,1,1,"title","Nadaraya-Watson")
  setgopt(d,1,2,"title","Local Linear")


