proc(AR1res)=AR1res(x)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    genarma
; ---------------------------------------------------------------------
; Macro       AR1res
; ---------------------------------------------------------------------
; Description Estimation of the AR(1) Residuals and calculation of a
;							series by this estimate 
; ---------------------------------------------------------------------
; Usage       (AR1res)=AR1res(x)
; Input       
; Parameter   x	input series length n
; Definition  
; Output      
; Parameter   AR1res output series length n-1
; Definition  
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     x=normal(6)
;							x=cumsum(x)
;							ar=AR1res(x)
; ---------------------------------------------------------------------
; Result      Contents of ar
;							[1,] -0.19035
;							[2,] -0.86272
;							[3,]  0.088414
;							[4,] -0.16921
;							[5,]  0.85727 
; ---------------------------------------------------------------------
; Keywords    
; ---------------------------------------------------------------------
; Reference   
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 000412
; ---------------------------------------------------------------------
//
n=rows(x)
i=1
x0=matrix(n-1)
x1=matrix(n-1)
while (i<n-1)
	i=i+1
	x0[i-1]=x[i]
	x1[i-1]=x[i-1]
endo
{b,bse,bstan,bval}=linreg(x1,x0)
i=0
y=matrix(n-1)
while (i<n-1)
	i=i+1
	y[i]=x[i+1]-b[2]*x[i]
endo
AR1res=y
//b=b[2]
endp