proc(gk)=FARgk(m,d)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    FARcov, FARx, genarma
; ---------------------------------------------------------------------
; Macro       FARgk
; ---------------------------------------------------------------------
; Description Calculation of the gk for Simulation of fractional 
;							ARIMA(0,d,0) with FARx
; ---------------------------------------------------------------------
; Usage       (gk)=FARgk(m,d)
; Input       
; Parameter   m	length of the generated series in FARx, must be a power
; Definition    of 2 due to the Fast Fourier Transform
; Parameter   d self similarity parameter d=H-1/2
; Definition  
; Output      
; Parameter   gk vector of the calculated gk (length 2*n)
; Definition  
; ---------------------------------------------------------------------
; Notes     	needs FARcov  
; ---------------------------------------------------------------------
; Example     gk=FARgk(2,.3)
; ---------------------------------------------------------------------
; Result      Contents of gk
;							[1,]   2.8764
;							[2,]  0.88505
;							[3,]  0.61953
;							[4,]  0.88505
; ---------------------------------------------------------------------
; Keywords    covariance function
; ---------------------------------------------------------------------
; Reference   Beran, J. "Statistics for Long Memory Processes", Chapman
;							& Hall 1994
;							Davies, R.B. and Harte, D.S. Test for Hurst effect"
;							Biometrica 74, 1987
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 000402
; ---------------------------------------------------------------------
//
n=m+1
gammak=FARcov(n,d)
i=0
cvre=matrix(2*(n-1))
cvim=matrix(2*(n-1))-matrix(2*(n-1))
while  (i<n-1)
  i=i+1
  cvre[i]=gammak[i]
  cvre[2*(n-1)-i+1]=gammak[i+1]
endo
cv=matrix(2*(n-1),2)
cv=cvre~cvim
gk=fft(cv)[,1]
endp