proc(FGNchol)=FGNchol(n,H)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    FGNx
; ---------------------------------------------------------------------
; Macro       FGNchol
; ---------------------------------------------------------------------
; Description Simulation of a series standard fractional Brownian 
;							Motion by the exact cholesky decomposition
; ---------------------------------------------------------------------
; Usage       (FGNchol)=FGNchol(n,H)
; Input       
; Parameter   n	length of the series (caution with values greater than
; Definition  	200 due to matrix manipulation)
; Parameter   H self similarity parameter of the generated series
; Definition  
; Output      
; Parameter   FGNchol vector of the generated series
; Definition  
; ---------------------------------------------------------------------
; Notes       uses Cholesky Decomposition, generated series is standard
;							(variance=1) fractional Gaussian Noise
; ---------------------------------------------------------------------
; Example     x=FGNchol(4,.7)
; ---------------------------------------------------------------------
; Result      Contents of x
;							[1,] -0.75719
;							[2,] -0.58049
;							[3,]  -1.4735
;							[4,]   1.0315
; ---------------------------------------------------------------------
; Keywords    fractional Gaussian Noise, fractional Brownian Motion
;							self similarity
; ---------------------------------------------------------------------
; Reference   Beran, J. "Stastitics for Long Memory Processes", Chapman
;							& Hall 1994
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 000410
; ---------------------------------------------------------------------
//
k=0
gammak=matrix(n)
while (k<n)
  k=k+1
  gammak[k]=((k+1)^(2*H)-2*k^(2*H)+(k-1)^(2*H))/2
endo
i=0
gamma=matrix(n,n)
while (i<n)
  i=i+1
  j=0
  while (j<n)
      j=j+1
      if (i-j==0)
        gamma[i,j]=1
      else
        gamma[i,j]=gammak[abs(i-j)]
      endif
  endo
endo
cholgamma=chol(gamma)
z=normal(n)
FGN=cholgamma*z
endp