proc(FGNcov)=FGNcov(n,H)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    FGNgk,FGNx,FBMx
; ---------------------------------------------------------------------
; Macro       FGNcov
; ---------------------------------------------------------------------
; Description Calculation of the aotocovariance function of fractional
;							Gaussian noise
; ---------------------------------------------------------------------
; Usage       (FGNcov)=FGNcov(n,H)
; Input       
; Parameter   n length of vector for the calculated autocovariances 
; Definition  
; Parameter   H Hurst coefficient
; Definition  
; Output      
; Parameter   FGNcov vector of the autocovariances
; Definition  
; ---------------------------------------------------------------------
; Notes     	
; ---------------------------------------------------------------------
; Example     cov=FGNcov(4,.7)
; ---------------------------------------------------------------------
; Result      Contents of cov
;							[1,]       1
;							[2,] 0.31951
;							[3,] 0.18875
;							[4,] 0.14617
; ---------------------------------------------------------------------
; Keywords    fractional Brownian Motion, fractional Gaussian Noise
;							self similarity
; ---------------------------------------------------------------------
; Reference   Beran, J. "Statistics for Long-Memory Processes" Chapman
;							& Hall 1994
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wnsche, 000402
; ---------------------------------------------------------------------
//
k=0
alpha=2*H
cov=matrix(n)
while (k<n)
  cov[k+1]=((abs(k-1))^alpha-2*(abs(k))^alpha+(abs(k+1))^alpha)/2
  k=k+1
endo
FGNcov=cov
endp