proc(A,b,ctrl) = absepnewton(e,S1,S2,itmax,eps,A0,b0,aus)
; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC, ICerzsep 
; -----------------------------------------------------------------
;   Macro        absepnewton
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rICfil:
;                solves - if possible - by explicit integration
;                 and Newton-Algorithm
;                (separate clipping in 1 dimension 
;                 of normal scores  X=X1+X2, X1,X2 indep.)
;
;       E [A (X1 \min{1,b/|AX1|} +X2) (X1+X2) ]=1, 
;
;       E [A^2 (X1 \min{1,b/|AX1|} +X2)^2]=(1+e) /(S1+S2)
;
;                for X=X1+X2, X1 ~ N(0,S1), X2 ~ N(0,S2) indep1
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          {A,b,ctrl}=absepnewton(e,S1,S2,itmax,eps,A0,b0,aus)
;   Input
;     Parameter   e  
;     Definition     numeric; efficiency loss to attain;
;     Parameter   S1  
;     Definition     numeric; Variance of X1 (the clipped part of X);
;     Parameter   S2  
;     Definition     numeric; Variance of X2 (the unmodified part of X);
;     Parameter    itmax
;     Definition      integer; maximal number of iterations
;     Parameter    eps
;     Definition      numeric; exactitude
;     Parameter   A0
;     Definition     numeric; starting value for a
;     Parameter   b0
;     Definition     numeric; starting value for b
;     Parameter   aus
;     Definition     integer; decides whether to write results on output [1] or not (else)
; Output                                                           
;     Parameter   A
;     Definition     numeric; Lagrange-Multiplyer to achieve Fisher-Consistency
;     Parameter   b
;     Definition     numeric; clipping height achieving e as rel. effiency loss
;     Parameter   ctrl
;     Definition     numeric; decides whether convergence "happened"
; -----------------------------------------------------------------
; Notes
;      Not to be used outside of rICfil!
; 
;      The Output produced if aus==1 is not identical with the output parameters.
;      (aus==1) is for interactive use ;   success is controlled by "verbal" output.
;      (aus==0) is for other quantlets calling absepnewton;
;      success is controlled by variable "ctrl".
;
;      Is called by 
;                   ICerz ICerzsep
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
  gr=30 
f=matrix(2)
x=matrix(2)
fabl=matrix(2,2)
;controll: reasonable starting values?
A=A0
b=(b0<=0)*2*sqrt(A*S1)+(b0>0)
alt=0
Aalt=0
fbet=1
it=0
del=1
 
x[1]=A
x[2]=b
c=b/A/sqrt(S1)

e1=cdfn(c)
e2=pdfn(c)
e3=2*e1-2*c*e2-1

f[1]=A*(S2+S1*(2*e1-1))-1
f[2]=A^2*(S2+S1*(e3+2*c^2*(1-e1)))-(e+1)/(S1+S2)

if (abs(f[1])<10^(-20))
f[1]=0
endif
if (abs(f[2])<10^(-20))
f[2]=0
endif
fbet=sqrt(f[1]*f[1]+f[2]*f[2])

ctrl=0

while (((del>eps)||(fbet>eps))&&(it<itmax))

   fabl[1,1]=S2+S1*e3
   fabl[1,2]= 2*sqrt(S1)*e2
   fabl[2,1]= 2*A*(S2+S1*e3) 
   fabl[2,2]=4*b*(1-e1)

   Aalt=A
   balt=b

   x=x-ginv(fabl)*f
   A=x[1]
   b=x[2]
   c=b/A/sqrt(S1)
   e1=cdfn(c)
   e2=pdfn(c)
   e3=2*e1-2*c*e2-1

   f[1]=A*(S2+S1*(2*e1-1))-1
   f[2]=A^2*(S2+S1*(e3+2*c^2*(1-e1)))-(e+1)/(S1+S2)

   fbet=sqrt(f[1]*f[1]+f[2]*f[2])

   if ((abs(A-Aalt)<10^(-20))&&(abs(b-balt)<10^(-20)))
       del=0
   else
       del=sqrt((A-Aalt)^2+(b-balt)^2)
   endif
    ;if ((b<0)||(A<0)||(A>30*S1/(S1+S2))||(b>30*S1/(S1+S2)))
   ;  ctrl=1  
   ;   it=2* itmax 
  ;endif  
   it=it+1

endo
if (aus==1)
 ; A
 ; b
ctrl=ctrl+(it>=itmax)+(b<0)+(A<0)+(A>30*S1/(S1+S2))+(b>30*S1/(S1+S2))
;  "Control of the defining equations:"
;   "Value of (Ew[psi Lambda]-1)  [to be 0]:  _f[1]_"
;   "Value of (Ew[psi^2]-(1+e)/I)  [to be 0]:  _f[2]_"
endif


endp