proc(slist)=addlist(s0,s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s12,s13,s14,s15,s16,s17,s18,s19)
; ----------------------------------------------------------------------------
; Library       xplore
; ----------------------------------------------------------------------------
;  See_also     list append comp names
; ----------------------------------------------------------------------------
;  Keywords     list, list manipulation
; -----------------------------------------------------------------
;   Macro       addlist
; ----------------------------------------------------------------------------
;   Description  Adds components to an existing list or creates a new
;                list with specific components.
; ----------------------------------------------------------------------------
;   Notes        (1) addlist is more powerful than list or append, since 
;                    it can handle the name of a component and the value 
;                    separately. 
;                
;                (2) The total number of input arguments is restricted 
;                    to 20. -- This is not a real restriction, since the
;                    function can be applied subsequentially.
;                
;                (3) As it holds for lists in general: there can be
;                    different list components with the same name.
; ----------------------------------------------------------------------------
;   Usage        newlist=addlist({oldlist,} name1, value1 {,name2, value2, ...}
;   Input
;     Parameter   oldlist
;     Definition        optional, string, name of an existing list to
;                       add components.
;     Parameter   name1, name2, ...
;     Definition        string, name of the list component.
;     Parameter   value1, value2, ...
;     Definition        numeric, string, or list, value of the list component.
;   Output
;     Parameter   newlist
;     Definition        resulting list.
; ----------------------------------------------------------------------------
;   Example   library("xplore")
;             mylist=addlist("day",9831,"message","Hi!")
;             mylist=addlist(mylist,"question","Did you get it?")
;             mylist
; ----------------------------------------------------------------------------
;   Result    Content of object mylist.day
;             [1,]     9831 
;             Content of object mylist.message
;             [1,] "Hi!"
;             Content of object mylist.question
;             [1,] "Did you get it?" 
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 980301
; ----------------------------------------------------------------------------
;
  if (exist(s0)==9)
    slist=s0
    jstart=-1
  else
    error((exist(s0)==2)&&(exist(s1)<=0),"addlist: component without value!")
    exec( s0+"=s1" )
    exec( "slist=list("+s0+")" )
    jstart=0
  endif
;
  j=jstart
  while (j<19)
    j=j+2
    j0 =string("%1.0f",j)
    j1 =string("%1.0f",j+1)
    ex0=0
    exec( "ex0=exist(s"+j0+")" )
    ex1=0
    exec( "ex1=exist(s"+j1+")" )
    error((ex0==2)&&(ex1<=0),"addlist: component without value!")
    if ((ex0==2)&&(ex1>0))
      sj0="s"+j0
      sj1="s"+j1
      exec( "s0="+sj0 )
      exec( "s1="+sj1 )
      exec( s0+"=s1" )
      exec( "append(slist,"+s0+")" )
    else
      j=19
    endif
  endo
endp
