proc(y) = betrnormE(t,n)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC, ICerzsep, ICerz
; -----------------------------------------------------------------
;   Macro        betrnormE
; -----------------------------------------------------------------
;   Description  Auxiliary routine for ricfil:
;                calculates the E  [ |X| (|x|<t) ], 
;                X an n-dim  standard normal variate  
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage         y=betrnormE(t,n)
;   Input
;     Parameter   t  
;     Definition     numeric; clipping point
;     Parameter   n 
;     Definition      integer; dim of X
; Output                                                           
;     Parameter   y
;     Definition      numeric;n-th clipped moment
; -----------------------------------------------------------------
;  Notes
;     Not to be used outside of ricfil!
;
;     Is called by ewinn.
; 
;      Calles [within kalman.lib]  nmomnorm.
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
  
wup=sqrt(2*pi)
y1=nmomnorm (t,n)
y2=nmomnorm (0,n)
if (n==1)
    f=2
else 
    if (n==2)
        f=wup
    else     
       n2=floor((n-1)/2)
        i=2*(1:n2)
        if (n%2==1) 
            i=i-1
            fac=prod(i)    
            f=2/fac
        else 
           fac=prod(i)
           f=wup/fac
       endif
    endif
endif
y=f*(y1-y2)

endp
