proc(y) = betrnormV(t,n)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rICfil, calibrIC, ICerzsep, ICerz
; -----------------------------------------------------------------
;   Macro        betrnormV
; -----------------------------------------------------------------
;   Description  Auxiliary routine for ricfil:
;                calculates E  [ |X|^2 (|x|<t) ], 
;                X an n-dim  standard normal variate  
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rIC
; -----------------------------------------------------------------
;   Usage          y=betrnormV(t,n)
;   Input
;     Parameter   t  
;     Definition     numeric; clipping point
;     Parameter   n 
;     Definition      integer; dim of X
; Output                                                           
;     Parameter   y
;     Definition      numeric;n-th clipped moment
; -----------------------------------------------------------------
; Notes
;     not to be used outside of ricfil!
; 
;      Is called by ew2inn ewinn.
; 
;      Calles [within kalman.lib]  nmomnorm.
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
;   Example   to be looked up in rICfil
; -----------------------------------------------------------------
  
wup=sqrt(2*pi)
y1=nmomnorm (t,n+1)
y2=nmomnorm (0,n+1)
if (n==1)
    f=2
else 
    if (n==2)
        f=wup
    else     
       n2=floor((n-1)/2)
        i=2*(1:n2)
        if (n%2==1) 
            i=i-1
            fac=prod(i)    
            f=2/fac
        else 
           fac=prod(i)
           f=wup/fac
       endif
    endif
endif
y=f*(y1-y2)

endp
