proc(data)=boxcoxs(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istatransformation
; -----------------------------------------------------------------------
; Macro        boxcoxs
; -----------------------------------------------------------------------
; Description  performs a  box-coxs transformation of the selected 
;              variables in ISTA. The transformed variables can replace
;              the original ones or can be appended on the end of data.x.
;              The type is set automatically to continuous.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------  
  data    = datain
  datah   = datain
  datah1   = paf(data.x, data.rowcase&&data.randcase&&data.rowmissing)
  ind=paf(1:rows(data), data.rowcase&&data.randcase&&data.rowmissing)
  stringh = data.colname
  colth   = data.coltype
  colvh   = data.colvar  
  colmh   = data.colmissing
  text="(Box-Cox)"
  ;selitem=data.colname
  ;sel=selectitemlist(selhead,selitem,15)
   sel=choosevariable2(data,text)
  i=0
  while (i.<rows(sel))
    i = i+1
    if(sel[i])  
      m = min(datah[,i])
      if (m<0)
        vs = abs(m)+1|1
      else
        vs = 0|1    
      endif
      vstr= stringh[i] + " c:"|stringh[i] + " p:" 
      doit=0
      do
        v= readvalue(vstr, vs)
        if((m<0)&&(v<abs(m))&&(abs(v[2]).<1.0e-6))
        ;Warnung nur fur Fall, dass Operation "ln(arg)", d.h. p=0
          sel1 = selectitem("Warning: x+c has to be >0", "Do it !"|"New ?", "single")
          ;Es sei dem Benutzer ueberlassen, ob er NanNs als Ergebniss will            
        if (sel1[1])
            doit = 1
          endif
          if (sel1[2])
            doit = 0
          endif
          else
            doit = 1
        endif
      until (doit)
      ;so lange Wahl von c, bis ln fuer x+c >0 oder Benutzer NaNs akzeptiert
      if(abs(v[2]).<1.0e-6)
        selhead2="Create a new variable?"
        selitem2="Yes"|"No"
        sel2=selectitem(selhead2,selitem2,"single")  
        if(sel2[2])  
          xneu=NaN*matrix(rows(data))
          xneu[ind]=log(datah1[,i]+v[1])
          datah[,i]=xneu
        endif
        if(sel2[1]) 
          xneu=NaN*matrix(rows(data))
          xneu[ind]=log(datah1[,i]+v[1])
          datah=datah~xneu
          stringh1=string("X%.0f", cols(datah)) 
          stringh=stringh|readvalue("New variablename:", stringh1)
          colth=colth|0 ;Annahme, dass neue Variable kontinuierlich
          colvh=colvh|1 ;Neue Variable natuerlich "nicht deleted"
          colmh=colmh|1 ;Neue Variable n colmh=colmh|1 ;Neue Variable natuerlich "nicht deleted"
        endif
      else
        selhead2="Create a new variable?"
        selitem2="Yes"|"No"
        sel2=selectitem(selhead2,selitem2,"single")
        if(sel2[2])  
          xneu=NaN*matrix(rows(data))
          xneu[ind]=((datah1[,i]+v[1])^v[2]-1)/v[2]
          datah[,i]=xneu
        endif
        if(sel2[1]) 
          xneu=NaN*matrix(rows(data))
          xneu[ind]=((datah1[,i]+v[1])^v[2]-1)/v[2]
          datah=datah~xneu
          stringh1=string("X%.0f", cols(datah)) 
          stringh=stringh|readvalue("New variablename:", stringh1)
          colth=colth|0 ;Annahme, dass neue Variable kontinuierlich
          colvh=colvh|1 ;Neue Variable natuerlich "nicht deleted"
          colmh=colmh|1 ;Neue Variable n colmh=colmh|1 ;Neue Variable natuerlich "nicht deleted"
        endif
      endif
    endif
  endo
  data.x=datah
  data.colname=stringh
  data.coltype=colth
  data.colvar=colvh
  data.colmissing=colmh
endp
