proc (y) = cabs (x)  
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     
; -----------------------------------------------------------------------
; Macro        cabs
; -----------------------------------------------------------------------
; Description  Absolute value of a complex array
; -----------------------------------------------------------------------
; Usage        y = cabs (x)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  y
;   Definition n x p x d1 x ... x dn array
; -----------------------------------------------------------------------
; Example      library("math")
;              z = complex (1,1)
;              cabs(z)
; -----------------------------------------------------------------------
; Result       //Squareroot of 2
;              Contents of y
;              [1,]   1.4142 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960327, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cabs : No real part in x found")
  error (comp(x, "im")<1, "cabs : No imaginary part in x found")
  y = sqrt (x.re^2 + x.im^2)  
endp  



