 proc(x,namel,namec,xl,namesl,xc,namesc) = cagetdata(dn,ln,cn,dln,sln,dcn,scn)
; -----------------------------------------------------------------
;    Library    stats
; -----------------------------------------------------------------
;    See_also  corresp
; -----------------------------------------------------------------
;    Macro  cagetdata
; -----------------------------------------------------------------
;    Description    supplementary macro for corresp which performs
;           correspondence analysis for a contingency table
; -----------------------------------------------------------------
;   Link ../tutorials/correspondence.html  Correspondence Analysis
;-----------------------------------------------------------------
;   Author   Vila  CO ,  970904, Michal Benko, 000417
; --------------------------------------------------------
     x=read(dn)                   /* name of active data file      */
     if(ln!="null")
        namel=readm(ln)           /* name of row-points file       */
        namel=namel.text         /* added by michal */
     else
        namel=string("%4.0f",#(1:rows(x)))
     endif
     if(cn!="null")
        namec=readm(cn)           /* name of column-points file    */
        namec=namec.text          /* added by michal */
     else
        namec=string("%4.0f",#(1:cols(x)))
     endif
     if(dln!="null")
         xl=read(dln)             /* name of supplementary (row) data file    */
         if(sln!="null")
            namesl=readm(sln)     /* name of supplementary row-points file    */
            namesl=namesl.text    /* added by michal */
         else
            namesl=string("%4.0f",#(1:rows(xl)))
         endif
     else
          xl=0
          namesl="null"
     endif
     if(dcn!="null")
         xc=read(dcn)             /* name of supplementary (column) data file */
         if(scn!="null")
            namesc=readm(scn)     /* name of supplementary column-points file */
            namesc=namesc.text    /* added by michal */
         else
            namesc=string("%4.0f",#(1:cols(xc)))
         endif
     else
         xc=0
         namesc="null"
     endif
 endp






