proc (z) = cconj (x)
; -----------------------------------------------------------------------
; Library      math 
; -----------------------------------------------------------------------
; See_also     cpolar
; -----------------------------------------------------------------------
; Macro        cconj
; -----------------------------------------------------------------------
; Description  Conjugated array
; -----------------------------------------------------------------------
; Usage        z = cconj (x)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              z = complex (0, 1)
;              cconj (z)
; -----------------------------------------------------------------------
; Result       Contents of z.re
;              [1,]        0
;              Contents of z.im
;              [1,]       -1 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960327, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cconj : No real part in x found")
  error (comp(x, "im")<1, "cconj : No imaginary part in x found")
  re = x.re
  im = -x.im
  z  = list(re, im)
endp  


