proc (z) = cdiv (x, y)  
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cadd cmul csub
; -----------------------------------------------------------------------
; Macro        cdiv
; -----------------------------------------------------------------------
; Description  Complex division
; -----------------------------------------------------------------------
; Usage        z = cdiv (x, y)
; Input
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
;   Parameter  y
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              one = complex(1, 0) 
;              j   = complex(0, 1)
;              cdiv (j, one)
; -----------------------------------------------------------------------
; Result       Contents of z.re 
; 		         [1,]        0
;              Contents of z.im
; 		         [1,]        1
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960327, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cdiv : No real part in x found")
  error (comp(x, "im")<1, "cdiv : No imaginary part in x found")
  error (comp(y, "re")<1, "cdiv : No real part in y found")
  error (comp(y, "im")<1, "cdiv : No imaginary part in y found")  
  w  = y.re^2 + y.im^2
  re = (x.re.*y.re + x.im.*y.im) ./ w  
  im = (x.im.*y.re - x.re.*y.im) ./ w  
  z  = list(re,im)
endp  



