proc (z) = cln (x)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     ccos ccosh cexp csin csinh ctan ctanh csqrt
; -----------------------------------------------------------------------
; Macro        cln
; -----------------------------------------------------------------------
; Description  Complex natural logarithm
; -----------------------------------------------------------------------
; Usage        z = cln (x)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Note         z.re+i*(z.im+2*pi*k) k=...,-1,1,... are solutions, too 
; -----------------------------------------------------------------------
; Example      library("math")
;              j = complex(0, 1)
; 	       cln (j)
; -----------------------------------------------------------------------
; Result       Contents of z.re
; 		         [1,]        0 
;              Contents of z.im
;		           [1,]   1.5708 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  re = log(x.re^2+x.im^2) ./ 2
  im = atan2(x.im, x.re)
  z  = list(re,im)
endp

