proc (z) = cmatmul (x, y) 
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cinv cmatdiv
; -----------------------------------------------------------------------
; Macro        cmatmul
; -----------------------------------------------------------------------
; Description  Computes the complex matrix multiplication of X and Y
; -----------------------------------------------------------------------
; Usage        z = cmatmul (x, y)
; Input
;   Parameter  x
;   Definition complex matrix X
;   Parameter  y
;   Definition complexr matrix Y
; Output
;   Parameter  z
;   Definition complex matrix
; -----------------------------------------------------------------------
; Example      library("math")
;              x = complex (#(-2, 0)~#(-1, -2), #(-1, 0)~#(-3, -1))
;              y = complex (#(-2, -1)~#(-1, 0), #(-1, 0)~#(0, 0))
;              cmatmul (x, y)
; -----------------------------------------------------------------------
; Result       Contents of z.re

;              [1,]        4        2 
;              [2,]        2        0 
;              Contents of z.im

;              [1,]        7        1 
;              [2,]        1        0 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cmatmul : No real part in x found")
  error (comp(x, "im")<1, "cmatmul : No imaginary part in x found")
  error (comp(y, "re")<1, "cmatmul : No real part in y found")
  error (comp(y, "im")<1, "cmatmul : No imaginary part in y found")  
  re = x.re*y.re - x.im*y.im 
  im = x.re*y.im + x.im*y.re
  z  = list(re,im)
endp


