proc(data)=committee(datain,x,y)    
; -----------------------------------------------------------------------
; Library      nn 
; -----------------------------------------------------------------
; See_also     neuronal, nnrnet, nnrpredict, nnrinfo
; -----------------------------------------------------------------------
; Macro        committee
; -----------------------------------------------------------------------
; Description  This macro computes a committee of networks with nets of
;              the form single
;              layer feedforward perceptron. The macro can be used alone 
;              or in connection with the library ISTA. The standalone version
;              also needs the parameter data. Just choose 0 for the input.
;              The number of nets to build the committee can be chosen.
;              The data will be splitted with this number to build the 
;              different datasets.  The weight for the cases for the training
;              of the net can be chosen, the numbers of hidden units and 
;              additional information concerning the weights of the units.        
;              Different optional parameters can be chosen to 
;              build the architektur of the network. The choice holds for
;              every single net. The default values are chosen in
;              order to solve a linear regression problem. The optional
;              parameters constits of 8 values. Boolean values for linear
;              output, entropy error function, log probability models and
;              for skip connections (direkt links). The fifth values is
;              the maximum value for the starting weights, the sixth is the 
;              weight decay, the seventh the maximum number of iterations
;              and the the last value generates the output concerning the 
;              architekur of the net if it is equal to one.
;              The output consits of the Error and MSE of the single nets
;              and for all cases. Additionally the R^2 for the average of
;              the nets and the R^2 of the committee are shown. 
;                 
;----------------------------------------------------------------------
; Usage        proc(data)=committee(datain,x,y)   
; Input
;   Parameter  x 
;   Definition n x p x d1 x ... x dn array    
;   Parameter  y 
;   Definition n x 1 array  
;   Parameter  datain 
;   Definition for use in ISTA: n x p x d1 x ... x dn array   
;              otherwise:       0    
; Output
;   Parameter  data
;   Definition for use in ISTA: n x p x d1 x ... x dn array   
;              otherwise: 0
; -----------------------------------------------------------------------
; Example      library("nn")
;              datain=0
;              z=read("bostonh")
;              x=z[,1:13]
;              y=z[,14]
;              committee(datain,x,y)  
; -----------------------------------------------------------------------
; Result       Choose 4 single nets to build teh committee. 
;              For the number of units in hidden layer choose 3, for the
;              weight decay 0.01 with 500 iterations and one for the output.
;              The architektur of the nets in the committee consists of:
;
; A 13 - 3 - 1 network: 
; # weights     : 46 
; linear output : yes 
; error function: least squares 
; log prob model: no 
; skip links    : no 
; max. weight   : 0.70 
; decay         : 0.01 
; max. Iterat   : 500 
;
; committee networks 
; net  Error (single net) MSE (single net)  MSE (all cases) 
; _________________________________________________________ 
;   1           4126.8667          10.4246           0.4772   
;   2           4136.4091          11.0771          29.9052   
;   3           3854.8416          10.4423          18.9735   
;   4           3634.2495           9.2975           8.1649   
; _________________________________________________________
; MSE of networks  14.3802      R^2: 0.8297 
; MSE due to committee  2.4619  R^2: 0.9708   
;-----------------------------------------------------------------------
; Keywords     nnfunc nninit nnrdovm nnrsetnet nnrsettrain nnrtest nnvisu
;              nnpredict nninfo neuronal
;-----------------------------------------------------------------------
; Author       Kerstin Zanter   980331
; ----------------------------------------------------------------------
; Reference    Venables, W. N. and Ripley, B. D. (1994),
;              Modern Applied Statistics with S-Plus, p. 261-266
;
;              Bishop, C. M. (1995),
;              neuronal Networks for Pattern Recognition
; ----------------------------------------------------------------------
    data=datain
    n=rows(x)
    c=cols(x)
    nstr="Number of networks"
    th=4
    do
      t=readvalue(nstr,th)
    until(t>0)
    tf = floor(t*uniform(rows(x))) 
    selheadt="Committee networks: option for all nets"
    selitemt="Number of units in Hidden layer"
    selitemt=selitemt|"additional parameters"|"additional information"
    selt=selectitem(selheadt,selitemt)
    if(selt[1])
      hstr="number of hidden units"
      h=floor(sqrt(cols(x)+cols(y)))
      size=readvalue(hstr,h)    
    else
      size=floor(sqrt(cols(x)+cols(y)))
    endif 
    if(selt[2])
      pstr="Linear output units"|"Entropy error function"|"Log prob model"
      pstr=pstr|"Direct links"|"Normal random for weights [-rang, +rang]"
      pstr=pstr|"Weight decay"|"Maximum number of iterations"|"Output"
      p=1|0|0|0|0.7|0|100|0
      par=readvalue(pstr,p)
      if(sum(par[1]&&par[2]))
        warning="Entropy error fit only for logistic units (classification)"
        warning
        do
          pstr1="Linear output units"|"Entropy error function"
          p1=0|0
          par[1:2]=readvalue(pstr1,p1)
        until(sum(par[1:2])<=1)
       endif
       if(sum(par[3]))
         par[1]=1
         par[2]=0
       endif
    else
      par=1|0|0|0|0.7|0|100|0
    endif    
    if(selt[3])
      predict=1
    else
      predict=0
    endif
    tf = floor(t*uniform(rows(x))) 
    i=0
    yhtotal=0.*matrix(rows(y),t)
    e=matrix(t)
    mseyhpart = matrix(t)
    while(i<t)
      xhelp = paf (x, tf<>i)
      yhelp = paf (y, tf<>i)
      i=i+1
      weights = matrix(rows(xhelp))
      net=nnrnet(xhelp,yhelp,weights,size,par) 
      if(sum(predict))
        nnrinfo(net)
      endif
      mseyhpart[i] = sum((yhelp-net.yh)^2)/rows(yhelp)
      e[i]=net.value
      yhtotal[,i]=nnrpredict(x,net)
    endo
    mseyhtotal = (sum(yhtotal-y)^2)/rows(y)
    mseav      = mean(mseyhtotal,2)
    SST=sum((y-mean(y))^2)
    SSEav      = mseav*rows(y)
    dim(SSEav)
    Rsquareav  = 1-SSEav/SST
    Rstrav     = string(" %5.4f",Rsquareav)
    yhav       = mean(yhtotal,2)
    msecom     = (sum(yhav-y)^2)/rows(y)
    SSEcom     = (sum(yhav-y)^2)
    Rsquarecom = 1-SSEcom/SST
    Rstrcom    = string(" %5.4f",Rsquarecom)
    firstline="committee networks"
    secondline="net  Error (single net) MSE (single net)  MSE (all cases)"
    thirdline="---------------------------------------------------------"
    tstr=string("%3.0f  ",1:t)
    estr=string("%18.4f  ",e)
    mseyhpartstr=string("%15.4f  ",mseyhpart)
    mseyhtotalstr=string("%15.4f  ",mseyhtotal')
    mseavstr=string("      %7.4f",mseav)
    msecomstr=string(" %7.4f",msecom)
    fourthline=tstr+estr+mseyhpartstr+mseyhtotalstr
    fifthline="-------------------------------------------------------"
    sixthline="MSE of networks"+mseavstr+"  R^2:"+Rstrav
    seventhline="MSE due to committee"+msecomstr+"  R^2:"+Rstrcom
    output=firstline|secondline|thirdline|fourthline|fifthline
    output=output|sixthline|seventhline
    output 
    if(sum(data))
      MSSRin=msecom
      selheads="Save new Variables?"
      selitems="Yes"|"No"
      sels=selectitem(selheads,selitems,"single")
      if(sels[1])  
        Vin=1:cols(x)
        b=0
        yhat=yhav
        cmd = "data=regressionsave(data,x,y,MSSRin,b,Vin,yhat)"
        exec(cmd)
      endif                                      
    if(sels[2])
    endif
  endif
endp