proc (r) = corr (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      cov var
; -----------------------------------------------------------------
;  Keywords      covariance, correlation
; -----------------------------------------------------------------
;   Macro        corr
; -----------------------------------------------------------------
;   Description  Computes the correlation (Bravais-Pearson)
;                structure of a given array.
; -----------------------------------------------------------------
;   Usage        r = corr (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  r  
;     Definition consists of covariance matrices of x
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = normal (200, 2, 3)
;             corr (x)
; -----------------------------------------------------------------
;   Result
;             Contents of r
;	      [,,1,1,1,1,1,1]
;	      [1,]     1 0.031623 
;	      [2,] 0.031623     1 
;	      [,,2,1,1,1,1,1]
;	      [1,]     1 0.011621 
;	      [2,] 0.011621     1 
;	      [,,3,1,1,1,1,1]
;	      [1,]     1 0.13138 
;	      [2,] 0.13138     1 
; -----------------------------------------------------------------
;   Author    TTK, 960207
; -----------------------------------------------------------------

  v = var (x)                        ; variance of each column of x
  r = cov (x) ./ (sqrt (v'*v))       ; v is row vector

endp

