proc(y) = corrint(x, m)  
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  distance
; ----------------------------------------------------------------------
;   Macro	  corrint
; ----------------------------------------------------------------------
;   Description   computes the correlation integral for time series
; ----------------------------------------------------------------------
;   Usage         y = corrint(x,m)
;   Input 
;     Parameter   x
;     Definition  vector
;     Parameter   m 
;     Definition  positive integer < 10 (embedding dimension)
;   Output
;     Parameter   y
;     Definition  array (first column: log epsilon, second column:
;			 log correlation integral)
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize (0)
;                 x=normal(100)
;                 y=corrint(x,2)
;                 y[1:2,1:2]
; ----------------------------------------------------------------------
;   Result        Contents of _tmp  (two first lines of y)
;                 [1,] -0.67811  -1.0089 
;                 [2,]  -0.6487 -0.99557
; ----------------------------------------------------------------------
;   Author        Christian Hafner, 960605
; ----------------------------------------------------------------------
  error((m<2 || m>10), "m must be in (2,3,...,9)")  
  error(cols(x)<>1, "X must be univariate!")  
  std=sqrt(var(x))  
  dk=9  
  k=matrix(dk)-1  
  r=20*m                                ; number of m-histories
  df=matrix(r, m)                       ; matrix of m-histories
  t=floor(uniform(r).*(rows(x)-m))+m    ; index vector
  i=1
  while(i<m) 
      t=t-1 
      df[,i]=index(x, t)                ; generate m-histories 
      i=i+1 
  endo 
  d=distance(df, "MAXIMUM")             ; compute r(r-1)/2 distances 
  i = 1:rows(d)^2  
  reshape ("i", #(rows(d), cols(d)))
  i = i<=i'
  d = paf (#(d), #(i))
  deps=1.5*std/99                       ; gap between two epsilons 
  oeps=0.5*std                          ; origin of epsilons 
  {xb,yb}=bindata(d, deps, oeps)        ; bin the distances      
  w=sort(xb~yb)                         ; sort the bins
  xc=conv(w[,1], w[,2], 0, 1)           ; avoid empty bins 
  w = xc{1}~cumsum(xc{2})./sum(xc{2}) 
  w = paf (w, ((w[,1].>=0) && (w[,1].<=100))) 
  epsk=log(0.5+(w[,1]+0.5).*1.5./99)~log(w[,2]) 
y=epsk
endp 
