proc(cov)=covmlrr(ord,rang,di,tb,te,typ,ytt)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     modelrr 
; -----------------------------------------------------------------
;   Macro        covmlrr
; -----------------------------------------------------------------
;   Description  covariance matrix used for reduced rank models 
; -----------------------------------------------------------------
;   Usage        cov=covmlrr(ord,rang,di,tb,te,typ,ytt)  
;   Input
;     Parameter   ord
;     Definition      scalar, model order
;     Parameter   rang
;     Definition      scalar, rank of VAR matrix
;     Parameter   di
;     Definition      scalar, dimension of time series
;     Parameter   tb 
;     Definition    scalar, beginning of sample
;     Parameter   te 
;     Definition    scalar, beginning of sample
;     Parameter   typ 
;     Definition    scalar, model type
;     Parameter   ytt 
;     Definition    matrix, transformed time series
;   Output
;     Parameter   cov
;     Definition    matrix, covariance matrix
; -----------------------------------------------------------------
;   Author    Christian Hafner 981230
; -----------------------------------------------------------------
t=te-tb+1
yr=ytt[,tb:te]-mean(ytt[,tb:te]')'
if (ord>0)
   c=estabr(ord,rang,di,tb,te,typ,ytt)
   c=c[1:di,]*c[di+1:rows(c),]'
   yx=ymulz(ord,di,tb,te,1,typ,ytt)
   xx=zmulz(ord,di,tb,te,1,0,typ,ytt)
else
   c=zeros(di,di)
   yx=c
   xx=c
endif
cov=(yr*yr'-yx*c'-c*yx'+c*xx*c')/t
endp;
