proc () = cplot (x,y) 
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cplotfunc
; -----------------------------------------------------------------------
; Macro        cplot
; -----------------------------------------------------------------------
; Description  Plot of x and y in absolute space
; -----------------------------------------------------------------------
; Usage        cplot (x, y)
; Input
;   Parameter  x 
;   Definition n x 1 complex vector
;   Parameter  y 
;   Definition n x 1 complex vector
; -----------------------------------------------------------------------
; Example      library("math")
;              x = complex (normal(100), normal(100))
;              y = cln(x)
;              cplot(x, y)
; -----------------------------------------------------------------------
; Result       plot of x and y
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970530
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cplot : No real part in x found")
  error (comp(x, "im")<1, "cplot : No imaginary part in x found")
  error (comp(y, "re")<1, "cplot : No real part in y found")
  error (comp(y, "im")<1, "cplot : No imaginary part in y found")  
  error (sum(dim(x)<>dim(y)), "cplot : dim(x)<>dim(y)")
  xp = sqrt(x.re^2+x.im^2)  
  yp = sqrt(y.re^2+y.im^2)
  cdisp = createdisplay(1, 1)
  show (cdisp, 1, 1, xp~yp)
endp  



