proc () = cplotfunc (y) 
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cplot
; -----------------------------------------------------------------------
; Macro        cplotfunc
; -----------------------------------------------------------------------
; Description  Plots a function of x and y-space
; -----------------------------------------------------------------------
; Usage        cplotfunc (y)
; Input
;   Parameter  y
;   Definition n x 2 complex matrix
; -----------------------------------------------------------------------
; Example      library("math")
;              g = grid (-2, 0.2, 41)
;              x = complex (g.*matrix(rows(g),rows(g)), g'.*matrix(rows(g),rows(g)))
;              y = cmul(x,x)             
;              cplotfunc(y)
; -----------------------------------------------------------------------
; Result       plot of y
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970530
; -----------------------------------------------------------------------
  error (comp(y, "re")<1, "cplot : No real part in y found")
  error (comp(y, "im")<1, "cplot : No imaginary part in y found")  
  cdisp = createdisplay(1, 1)
  n = rows(y.re)
  p = cols(y.re)
  pt = reshape(y.re, #(n*p,1))~reshape(y.im, #(n*p,1))
  setmaskp(pt,0,0,0)
  lt1 = grid(0, p, n)+trans(1:n).*matrix(n,p)
  if (n>p)
    lt1 = lt1~(0.*matrix(n,n-p))
  endif
  lt2 = lt1'
  if (p>n)
    lt2 = lt2~(0.*matrix(n,p-n))
  endif
  setmaskl(pt,lt1|lt2, 0,1,1)
  show (cdisp, 1, 1, pt)
endp  
