proc (z) = csub (x, y)       
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     cadd, cdiv, cmul
; -----------------------------------------------------------------------
; Macro        csub  
; -----------------------------------------------------------------------
; Description  Complex subtraction two arrays of complex numbers
; -----------------------------------------------------------------------
; Usage        z = csub (x, y)
; Input
;   Parameter  x 
;   Definition n x p x d1 x ... x dn complex array
;   Parameter  y
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              x = complex (#(1,3), #(2,1))
;	       y = complex (#(2,3), #(1,4))
;	       csub (x ,y)
; -----------------------------------------------------------------------
; Result       
;		Contents of z.re
;		[1,]       -1 
;   [2,]        0 	
;		Contents of z.im
;		[1,]        1 
;   [2,]       -3 	
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 970529, Susanne Hannappel, 960423
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "csub : No real part in x found")
  error (comp(x, "im")<1, "csub : No imaginary part in x found")
  error (comp(y, "re")<1, "csub : No real part in y found")
  error (comp(y, "im")<1, "csub : No imaginary part in y found")  
  re = x.re - y.re  
  im = x.im - y.im
  z  = list(re,im) 
endp



