proc(y)=denala(tr,dendat)
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     pinala kanta
; -----------------------------------------------------------------------
; Macro        denala
; -----------------------------------------------------------------------
; Description  Supporting Quantlet for cartsplit
; -----------------------------------------------------------------------
; Usage        ala = denala(tr, dendat)
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
; library ("xclust")
; randomize(1)
; dendat=uniform(10)~(uniform(10)+1)
; regdat=dentoreg(dendat,4)
; type=#(1,1)
; tr=cartsplit(regdat.ind,regdat.dep,type)
; ala=denala(tr,dendat)
; ala
;-----------------------------------------------------------------------
;Result  
;Contents of ala
;[ 1,] 0.624192 
;[ 2,] 0.078024 
;[ 3,] 0.234072 
;[ 4,] 0.078022 
;[ 5,] 0.546170 
;[ 6,] 0.390120 
;[ 7,] 0.390123 
;[ 8,] 0.234069 
;[ 9,] 0.546168 
;[10,] 0.390120 
;[11,] 0.390123 
;[12,] 0.234072 
;[13,] 0.390120 
;[14,] 0.234069 
;[15,] 0.234072 
;[16,] 0.390120 
;[17,] 0.234072 
;[18,] 0.078022 
;[19,] 0.546170 
;[20,] 0.390123
;[21,] 0.234069
;-----------------------------------------------------------------------
kantaja=kanta(dendat)
elem=dim(tr.nelem)
tulos=matrix(elem)
varlkm=dim(kantaja[,1])
binmat=matrix(varlkm,2*elem)
i=1
while (i<=elem)
  binmat[,2*i-1:2*i]=kantaja
  i=i+1
endo
tulos[1]=pinala(binmat[,1:2])
i=1
while (i<=elem)
   if (tr.vec[i]!=NaN)  ;ei olla lehdessa
      vasenlapsi=i+1
      binmat[tr.vec[i],2*vasenlapsi]=atof(tr.val{i})
      tulos[vasenlapsi]=pinala(binmat[,2*vasenlapsi-1:2*vasenlapsi])
      oikealapsi=endpoint(tr,i+1)+1
      binmat[tr.vec[i],2*oikealapsi-1]=atof(tr.val{i})
      tulos[oikealapsi]=pinala(binmat[,2*oikealapsi-1:2*oikealapsi])
   endif
   i=i+1
endo
y=tulos
endp
