proc(d)=dgenci(dy,yp,ord,c,b,e,di)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelci
; ----------------------------------------------------------------------
;   Macro	  dgenci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         d = dgenci(dy,yp,ord,c,b,e,di)
;   Input 
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   yp 
;     Definition     matrix, submatrix of time series
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   c 
;     Definition     matrix 
;     Parameter   b 
;     Definition     vector 
;     Parameter   e 
;     Definition     vector 
;     Parameter   di 
;     Definition     integer, dimension of time series
;   Output
;     Parameter   d
;     Definition     matrix
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ----------------------------------------------------------------------
  r0=rici(dy[,b:e],dy,ord,b,e,di);
  r1=rici(yp,dy,ord,b,e,di);
  d=-(r0*yp')*c'.*inv(c*r1*yp'*c')
endp;
