proc(dx)=diff(x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      tdiff
; -----------------------------------------------------------------
;  Keywords      difference
; -----------------------------------------------------------------
;   Macro        diff
; -----------------------------------------------------------------
;   Description  Computes first differences (along the rows) 
;                of an array.
; -----------------------------------------------------------------
;   Usage        dx = diff(x)
;   Input
;     Parameter  x  
;     Definition        array, d1 x d2 x ... x dn
;   Output
;     Parameter  dx
;     Definition        array, (d1-1) x d2 x ... x dn, first 
;                       differences along the rows of x.
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = (1:4)|6
;             diff(x)
; -----------------------------------------------------------------
;   Result    
;             Contents of object y
;	      [1,] 0
;	      [2,] 0
;	      [3,] 0
;	      [4,] 0
;	      [5,] 1
; -----------------------------------------------------------------
;   Author    TTK, Marlene Mueller, 970903
; -----------------------------------------------------------------
;
  n  = rows(x)
  dx = x[2:n] - x[1:(n-1)]
endp
