proc()=dispcart2(cartdisp, xnw, ynw, x, tree, ix, iy, mindepth, minssr)
; ---------------------------------------------------------------------
; Library     graphic
; ---------------------------------------------------------------------
; See_also    grcart2, cartsplit, tree
; ---------------------------------------------------------------------
; Macro       dispcart2
; ---------------------------------------------------------------------
; Description produces the cut graphic for a CART tree in a user 
;             specified display.
; ---------------------------------------------------------------------
; Usage       dispcart2(cartdisp,xnw,ynw,x,tree,ix,iy,mindepth,minssr)
; Input       
; Parameter   cartdisp
; Definition  display for showing the cuts
; Parameter   xnw
; Definition  scalar, column number of window
; Parameter   ynw
; Definition  scalar, row number of window
; Parameter   x
; Definition  nxp, 	X-variables used in cartsplit
; Parameter   tree
; Definition  list,	result of cartsplit
; Parameter   ix
; Definition  scalar,	which variable is taken for X
; Parameter   iy
; Definition  scalar,	which variable is taken for Y
; Parameter   mindepth
; Definition  scalar,	till which depth the tree should be shown
; Parameter   minssr
; Definition  scalar,	shows all cuts which produce a SSR larger than minssr
; Output      
; ---------------------------------------------------------------------
; Notes       The variables x[,ix] and x[,iy] must be continuous.
; ---------------------------------------------------------------------
; Example     randomize(1)
;             n=100
;             ; Generate some simulated data
;             xdat=uniform(n,2)
;             ydat=120.*matrix(n,1)-(xdat[,2]<=0.5).*120-(xdat[,2]>0.5).*(xdat[,1]<=0.5).*20
;             ydat=ydat+normal(n)
;             ; call CART
;             type=#(1,1)
;             opt=cartsplitopt("minsize",1,"mindev",0,"mincut",5)
;             tr=cartsplit(xdat,ydat,type,opt)
;             ; shows cuts
;             d=createdisplay(2,2)
;             dispcart2(d, 2, 2, xdat, tr, 1, 2, 3, 0)   
; ---------------------------------------------------------------------
; Result      shows the data and the cuts till depth 3 in the lower
;             right window of the display
; ---------------------------------------------------------------------
; Keywords    CART
; ---------------------------------------------------------------------
; Reference   Breiman, L., Friedman, J., Olshen, R., and Stone, C. J. (1984). 
;             Classification and Regression Trees. Chapman & Hall, New York
; ---------------------------------------------------------------------
; Link        ..\tutorials\cartstart.html CART Tutorial
; ---------------------------------------------------------------------
; Author      2000-03-17, Sigbert Klinke
; ---------------------------------------------------------------------
  line = grcart2(x, tree, ix, iy, mindepth, minssr) 
  xw   = x[,#(ix,iy)] 
  pcolor = 0
  pstyle = 3
  psize  = 8
  if (exist("x")==9)
    if (comp(x, "pcolor"))
      pcolor = x.pcolor
    endif
    if (comp(x, "pstyle"))
      pstyle = x.pstyle
    endif
    if (comp(x, "psize"))
      psize = x.psize
    endif
  endif
  setmaskp(xw, pcolor, pstyle, psize)
  show(cartdisp, xnw, ynw, xw, line)
endp
