proc(p, n, a) = divisive (x, k, w, m, sv)
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    kmeans adaptive agglom
; -----------------------------------------------------------------------
; Macro       divisive
; -----------------------------------------------------------------------
; Description performs an adaptive divisive K-means cluster
;             analysis with appropriate (adaptive)
;             multivariate graphic using principal components
; -----------------------------------------------------------------------
; Usage       cd = divisive (x, k, w, m, sv)
; Input
;   Parameter  x
;   Definition n x p  matrix of n row points to be clustered
;   Parameter  k
;   Definition scalar number of clusters
;   Parameter  w
;   Definition p x 1  matrix of weights of column points
;   Parameter  m
;   Definition n x 1  matrix of weights (masses) of row points
;   Parameter  sv
;   Definition scalar seed value for random numbers
;
; Output
;   Parameter  cd.p
;   Definition n x 1  matrix  partition of n points of x into k
;                             clusters
;   Parameter  cd.n
;   Definition k x 1  matrix of number of observations of clusters
;   Parameter  cd. a
;   Definition p x 1  matrix of final (pooled) adaptive weights of
;                     the variables    
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; initialize random generator
;             randomize(0)
;             ; generate basis data 
;             x  = normal(30, 5)
;             ; generate 4 clusters
;             x1 = x - #(2,1,3,0,0)'
;             x2 = x + #(1,1,3,1,0.5)'
;             x3 = x + #(0,0,1,5,1)'
;             x4 = x - #(0,2,1,3,0)'
;             x  = x1|x2|x3|x4
;             ; compute column variances
;             w  = 1./var(x)
;             ; compute row weights
;             m  = matrix(rows(x))
;             ; apply divisive
;             cd = divisive (x, 4, w, m, 1111)
;             ; compare estimated and true partition
;             conting (cd.p, 1+ceil((1:120)/30))
; -----------------------------------------------------------------------
; Result      Content of object h
;
;             [1,]        0       30        0        0 
;             [2,]        0        0       30        0 
;             [3,]       30        0        0        0 
;             [4,]        0        0        0       30 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 950121
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  j = cols(x)+1
  e = 1
  f = rows(x)
  r = aseq(1, rows(x), 1)
  u = matrix(f)
  cp = matrix(k+1).+f.-1
  cp[1,1] = 0
  vz = matrix(k)
  cond = 2
  randomize(sv)
  while (cond < k+0.5)
    {pt, c, v, q, a} = adap(x[e:f,], 2, w, m[e:f,], u[e:f,])
    t = sort(pt~x[e:f,]~m[e:f,]~r[e:f,])
    x[e:f,] = t[,2:j]
    m[e:f,] = t[,j+1]
    r[e:f,] =t[,j+2]
    s = conting(u[e:f,], pt)
    cp[cond,1] = s[1,1].+e.-1
    cp[2:cond+1,] = sort(cp[2:cond+1,])
    p=matrix(cp[2,1])
    jj=1
    while(jj<cond)
      p = p | matrix(cp[jj+2,1]-cp[jj+1,1]) .+jj
      jj=jj+1
    endo
;   ################ pooled weights
    {p, c, v, s} = kmeans(x, p, 30000, w', m)
    vv = sum(trans(v)*diag(s))'
    w = sum(s)./(s'*v)
  ; maximale Varianz unter k clustern
    vv = sort(vv~aseq(1, cond, 1), (-1))
    vz[cond,1] = vv[1,1]
    f = cp[vv[1,2]+1,1]
    e = cp[vv[1,2],1] +1
    cond = cond+1
    w=1./var(x[e:f,])
  endo
  n = conting(u, p)      
  m = sort(r~p)    
  p = m[,2]    
  a = var(x).*w    
endp    