proc()=dotplot(data)   
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista dotplotrech grdot gruppenvariable2
;              istagraphic showd 
; -----------------------------------------------------------------------
; Macro        dotplot
; -----------------------------------------------------------------------
; Description  shows a dotplot for the selected variables.
;              One or more group variables (disctrete type) can be 
;              selected. 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  coltype=matrix(rows(data.coltype)) 
  ;for variable selection both types are allowed
  dcoltype=data.coltype
  ;for group variable only discrete type 
  selvar=choosevariable(data,coltype)
  if(sum(selvar).>0) ;without selection back to graphicmenu 
    {r,c,l,d,titl}=gruppenvariable2(data, "dotplotrech",selvar,dcoltype)    
    showd(r,c,l,d,titl)
  endif
endp   
 