proc()=draftman(x, col, layout)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     pca factor
; -----------------------------------------------------------------------
; Macro        draftman
; -----------------------------------------------------------------------
; Description  Generates a draftman plot of X.
; -----------------------------------------------------------------------
; Usage        draftman(x {, col {,layout}})
; Input
;   Parameter  x
;   Definition n x p      matrix
;   Parameter  col
;   Definition color
;   Parameter  layout
;   Definition layout
; -----------------------------------------------------------------------
; Example      ; loads the library stats
;              library("stats")   
;              ; loads the library graphic
;              library ("graphic")
;              ; reads the swiss banknote data
;              x   = read("bank2")
;              ; sets the color to red
;              col = grc.col.red*matrix(200)
;              ; sets the symbol type to a circle for the genuine 
;              ; banknotes and a cross to  for the forged banknotes
;              layout= grc.sym.circle*matrix(100)|grc.sym.cross*matrix(100)
;              ; shows a simple draftman plot of the data
;              draftman(x, col, layout) 
; -----------------------------------------------------------------------
; Result       shows a scatterplot matrix
; -----------------------------------------------------------------------
; Author       Kerstin Zanter, 961202, Sigbert Klinke 970820
; -----------------------------------------------------------------------
  if (exist("col").<>1)
    col = 0
  endif
  if (exist("layout").<>1)
    layout = 8
  endif
  n = rows(x)
  p = cols(x)
  di=createdisplay(p,p)
  i=0
  while (i.<p)
    i=i+1
    j=0
    while (j.<p)
      j=j+1
      if (i>j)
        xx=x[,j]~x[,i]
        setmaskp(xx, col, layout, 8)
        show(di,i,j,xx)
      endif
      if (i==j)
        xlab=string("%1.0f.PC",j) 
        show(di,i,j,xlab)
      endif
    endo   
  endo
endp
