proc(mux,beta1,beta0,sigmax,sigmae,varbeta1,varbeta0)=eivknownvaru(w,y,sigmau)
; -----------------------------------------------------------------
;    Library	eiv
; -----------------------------------------------------------------
;    See_also eivknownatt eivknownratue
; -----------------------------------------------------------------
;    Macro	eivknownvaru
; -----------------------------------------------------------------
;    Description   eivknownvaru presents the moment estimates of the
;                  parameters in the measurement error models, which 
;                  has only one variable x. The variance of measurement 
;                  error sigma_u is known. All of the  variables obey 
;                  normal distributions. 
; ----------------------------------------------------------------------------
;   Reference     Fuller W. A. "Measurement Error Models", Wiley and Sons
;                 1987, section 1.2.
; -----------------------------------------------------------------
;    Link         ../tutorials/eivstart.html Tutorial: EIV in XploRe 
; -----------------------------------------------------------------
;    Usage    {mux,beta1,beta0,sigmax,sigmae,varbeta1,varbeta0} = eivknownvaru(w,y,sigmau)
;    Input
;      Parameter  w
;      Definition   n x 1 matrix, the design variables
;      Parameter  y
;      Definition   n x 1 matrix, the response
;      Parameter  sigmau
;      Definition   scalar, the variance of measurement error sigma_u
;    Output
;      Parameter  mux
;      Definition   scalar, the mean value of x
;      Parameter  beta1
;      Definition   scalar, the estimate
;      Parameter beta0
;      Definition  scalar, the estimate
;      Parameter sigmax
;      Definition  scalar, the estimate of the variance of x
;      Parameter sigmae
;      Definition  scalar, the estimate of the variance of error e
;      Parameter  varbeta1   
;      Definition  scalar, the estimate of the variance of the estimate of beta1
;      Parameter  varbeta0   
;      Definition  scalar, the estimate of the variance of the estimate of beta0
; -----------------------------------------------------------------
;  Example library("eiv")
;	   n = 100
;          randomize(n)
;	   x=9*normal(n)
;	   w=x+9*normal(n)
;          y=0.9+0.8*x+0.01*normal(n)
;	   sigmau=81
;	   gest=eivknownvaru(w,y,sigmau)
;	   gest.mux
;	   gest.beta1
;	   gest.beta0
;	   gest.sigmax
;	   gest.sigmae
;          gest.varbeta1   ; the estimate of the variance of the estimate of beta1
;          gest.varbeta0   ; the estimate of the variance of the estimate of beta0
; -----------------------------------------------------------------
;   Result Contents of mux
;          [1,] -0.93396 
;          Contents of beta1
;          [1,]  0.89725 
;          Contents of beta0
;          [1,]  0.42382 
;          Contents of sigmax
;          [1,]    64.17 
;          Contents of sigmae
;          [1,]   1.3344
;          Contents of varbeta1
;          [1,]  0.036895
;          Contents of varbeta0
;          [1,]  0.70441 
; -----------------------------------------------------------------
;   Author    Hua Liang,  990625
; -----------------------------------------------------------------
     n=rows(w)
     mux=mean(w)
     mxx=var(w)
     mxy=sum((w-mean(w)).*(y-mean(y)))/(rows(w)-1)
     myy=var(y)
     beta1=inv(mxx-sigmau)*mxy
     beta0=mean(y)-beta1*mean(w)
     sigmax=mxx-sigmau
     sigmae=myy-beta1*mxy
     svv=inv(n-2)*sum((y-mean(y)-beta1*(w-mean(w))).^2)
     varbeta1=inv(n-1)*sigmax^(-2)*(mxx*svv+beta1^2*sigmau^2)
     varbeta0=inv(n)*svv+(mean(w))^2*varbeta1
endp
