proc(notok)=eivtest()
; -----------------------------------------------------------------
; Library	eiv
; -----------------------------------------------------------------
;  See_also	eivknownatt eivknownvaru eivknownratue
; -----------------------------------------------------------------
;   Macro	eivtest
; -----------------------------------------------------------------
;   Description  eivtest verifies the EIV macros.
; -----------------------------------------------------------------
;   Link         ../tutorials/eivstart.html Tutorial: EIV in XploRe 
; -----------------------------------------------------------------
;   Usage	 notok = eivtest()
;   Input
;     Parameter
;     Definition	none
;   Output
;     Parameter   notok
;     Definition	'0' if test was o.k., '1' otherwise
; -----------------------------------------------------------------
;   Example   library("eiv")
;	            eivtest()
; -----------------------------------------------------------------
;   Result    Contents of notok
;	            [1,]     0
; -----------------------------------------------------------------
;   Author   Hua Liang, 970830
; -----------------------------------------------------------------
   n = 100
   beta1=0.8
   x= normal(n)*9
   w=x+9*normal(n)
   y =0.9+0.8*x+0.01*normal(n)
    kww =0.5
   sf1=eivknownatt(w,y,kww)
    sigmau=81
   sf2=eivknownvaru(w,y,sigmau)
    delta =0.0001/81
   sf3=eivknownratue(w,y,delta)
   crit1=sum(abs(sf2.beta1-sf1.beta1))./sum(abs(beta1))
    notok=(crit1>0.5)
    crit2=sum(abs(sf3.beta1-sf1.beta1))./sum(abs(beta1))
    notok=notok || (crit2>0.5)
endp
