proc(y,ew2)=estabr(ord,rang,di,tb,te,typ,ytt)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelrr
; ----------------------------------------------------------------------
;   Macro	  estabr
; ----------------------------------------------------------------------
;   Description   estimation of reduced rank VAR model
; ----------------------------------------------------------------------
;   Usage         {y, ew2} = estabr(ord,rang,di,tb,te,typ,ytt)
;   Input 
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   rang 
;     Definition     matrix 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   tb 
;     Definition     integer, (time) begin
;     Parameter   te 
;     Definition     integer, (time) end
;     Parameter   typ 
;     Definition     integer, describing the model type
;     Parameter   ytt 
;     Definition     vector, the transformed time series
;   Output
;     Parameter   y
;     Definition     matrix of parameters a and b
;     Parameter   ew2
;     Definition     matrix of eigenvalues
; ----------------------------------------------------------------------
;   Author        TP A1/A2, CH 980408
; ---------------------------------------------------------------------- 
  t=te-tb+1
  gam=inv((t-di*ord-1)/t*covres(ord,di,tb,te,1,typ,ytt))
  {ew1,ev1}=eigsm(gam)
  ev1=sort(ew1~ev1',1)
  ev1=ev1[,2:cols(ev1)]'
  ew1=sort(ew1,1)
  gamroot=ev1*diagrv(eye(di),ew1^(0.5))*ev1'
  gamstern=1/t*ymulz(ord,di,tb,te,1,typ,ytt)'
  gamp=1/t*zmulz(ord,di,tb,te,1,0,typ,ytt)
  gamip=inv(gamp)
  {ew2,ev2}=eigsm(gamroot*gamstern'*gamip*gamstern*gamroot)
  ev2=sort(ew2~ev2',-1)
  ev2=ev2[,2:cols(ev2)]'
  ew2=sort(ew2,-1)
  a=inv(gamroot)*ev2[,1:rang]
  b=ev2[,1:rang]'*gamroot*gamstern'*gamip
  y = a|b'        
endp
